<?php

class Awardit_AwsPersonalize_Model_Product extends MageQL_Catalog_Model_Product
{
    /**
     * @param mixed $unusedSrc
     * @param array{
     *   term: string,
     *   pageSize: ?int,
     * } $args
     */
    public static function productsByUserRecommend(
        $unusedSrc,
        array $args,
        MageQL_Core_Model_Context $ctx
    ): ?MageQL_Catalog_Model_Product_CollectionInterface {
        if (empty($args['user'])) {
            return null;
        }
        $skuList = Mage::helper('awardit_awspersonalize')->getProducts(
            Awardit_AwsPersonalize_Recommender::RECOMMEND,
            $args['user'],
            null,
            $args['pageSize'],
        );
        Mage::log('productsByUserRecommend: ' . json_encode($skuList)); // @todo: Remove debug
        return self::toCollection($ctx->getStore(), $skuList);
    }

    public static function productsByBestSeller(
        $unusedSrc,
        array $args,
        MageQL_Core_Model_Context $ctx
    ): ?MageQL_Catalog_Model_Product_CollectionInterface {
        if (empty($args['user'])) {
            return null;
        }
        $skuList = Mage::helper('awardit_awspersonalize')->getProducts(
            Awardit_AwsPersonalize_Recommender::BEST_SELLER,
            $args['user'],
            null,
            $args['pageSize'],
        );
        Mage::log('productsByBestSeller: ' . json_encode($skuList)); // @todo: Remove debug
        return self::toCollection($ctx->getStore(), $skuList);
    }

    public static function productsByBoughtTogether(
        $unusedSrc,
        array $args,
        MageQL_Core_Model_Context $ctx
    ): ?MageQL_Catalog_Model_Product_CollectionInterface {
        if (empty($args['sku'])) {
            return null;
        }
        $skuList = Mage::helper('awardit_awspersonalize')->getProducts(
            Awardit_AwsPersonalize_Recommender::BOUGHT_TOGETHER,
            null,
            $args['sku'],
            $args['pageSize'],
        );
        Mage::log('productsByBoughtTogether: ' . json_encode($skuList)); // @todo: Remove debug
        return self::toCollection($ctx->getStore(), $skuList);
    }

    private static function toCollection(
        Mage_Core_Model_Store $store,
        array $skuList,
        ?int $pageSize = null
    ): MageQL_Catalog_Model_Product_CollectionInterface {
        $collection = Mage::getResourceModel('catalog/product_collection');
        $collection->setStore($store);
        $collection->setVisibility(Mage::getSingleton('catalog/product_visibility')->getVisibleInCatalogIds());
        $collection->addAttributeToFilter('sku', ['in' => $skuList]);
        $collection->setPage(0, $pageSize ?? MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE_SIZE);
        return new MageQL_Catalog_Model_Product_Collection_ProductsByFilter($collection, $store);
    }
}
