<?php

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Awardit_AwsPersonalize_Model_Schema_Product extends MageQL_Core_Model_Schema_Abstract
{
    private Awardit_AwsPersonalize_Helper_Data $helper;

    public function __construct()
    {
        $this->helper = Mage::helper('awardit_awspersonalize');
    }

    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder
    {
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array
    {
        switch ($typeName) {
            case "Query":
                return array_filter([
                    'productsByUserRecommend' => $this->productsByUserRecommend(),
                    'productsByBestSeller' => $this->productsByBestSeller(),
                    'productsByBoughtTogether' => $this->productsByBoughtTogether(),
                ]);
        }
        return [];
    }

    private function productsByUserRecommend(): ?object
    {
        if (!$this->helper->isEnabled(Awardit_AwsPersonalize_Recommender::RECOMMEND)) {
            return null;
        }
        return $this
            ->field("FilterableProductList", "Todo")
            // @todo: Get from sessions?
            ->addArgument("user", $this->argument("String!", "User ID"))
            ->addArgument(
                "pageSize",
                $this->argument("Int", "Maximum number of products to list")
                    ->setDefaultValue(MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE_SIZE)
            )
            ->setResolver("Awardit_AwsPersonalize_Model_Product::productsByUserRecommend")
            ;
    }

    private function productsByBestSeller(): ?object
    {
        if (!$this->helper->isEnabled(Awardit_AwsPersonalize_Recommender::BEST_SELLER)) {
            return null;
        }
        return $this
            ->field("FilterableProductList", "Todo")
            // @todo: Get from sessions?
            ->addArgument("user", $this->argument("String!", "User ID"))
            ->addArgument(
                "pageSize",
                $this->argument("Int", "Maximum number of products to list")
                    ->setDefaultValue(MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE_SIZE)
            )
            ->setResolver("Awardit_AwsPersonalize_Model_Product::productsByBestSeller")
            ;
    }

    private function productsByBoughtTogether(): ?object
    {
        if (!$this->helper->isEnabled(Awardit_AwsPersonalize_Recommender::BOUGHT_TOGETHER)) {
            return null;
        }
        return $this
            ->field("FilterableProductList", "Todo")
            ->addArgument("sku", $this->argument("String!", "Product SKU"))
            ->addArgument(
                "pageSize",
                $this->argument("Int", "Maximum number of products to list")
                    ->setDefaultValue(MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE_SIZE)
            )
            ->setResolver("Awardit_AwsPersonalize_Model_Product::productsByBoughtTogether")
            ;
    }
}
