<?php

/**
 * JSON attribute backend for generic data.
 */
class Awardit_AttributeExtensions_Model_Backend_Json extends Mage_Eav_Model_Entity_Attribute_Backend_Abstract
{
    /**
     * JSON-encode before saving
     * @param Varien_Object $object
     * @return $this
     */
    public function beforeSave($object)
    {
        // parent::beforeSave() is not called intentionally
        $this->encode($object);
        return $this;
    }

    /**
     * JSON-decode after saving
     * @param Varien_Object $object
     * @return $this
     */
    public function afterSave($object)
    {
        parent::afterSave($object);
        $this->decode($object);
        return $this;
    }

    /**
     * JSON-decode after saving
     * @param Varien_Object $object
     * @return $this
     */
    public function afterLoad($object)
    {
        parent::afterLoad($object);
        $this->decode($object);
        return $this;
    }

    private function encode(Varien_Object $object): self
    {
        $attrCode = $this->getAttribute()->getAttributeCode();
        if ($object->hasData($attrCode)) {
            $object->setData($attrCode, $this->jsonEncode($object->getData($attrCode)));
        }
        return $this;
    }

    private function decode(Varien_Object $object): self
    {
        $attrCode = $this->getAttribute()->getAttributeCode();
        if ($object->getData($attrCode)) {
            $decoded = $this->jsonDecode($object->getData($attrCode));
            $object->setData($attrCode, $decoded);
        }
        return $this;
    }

    private function jsonEncode($data): string
    {
        return json_encode($data, JSON_PRESERVE_ZERO_FRACTION | JSON_THROW_ON_ERROR);
    }

    private function jsonDecode($data)
    {
        return json_decode($data, false, 512, JSON_THROW_ON_ERROR);
    }
}
