<?php

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_Antifraud_Block_Rule_Edit extends Mage_Adminhtml_Block_Widget_Form_Container
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    /**
     * Constructor for Fraud rule Edit block.
     */
    public function __construct()
    {
        $this->helper = Mage::helper('awardit_antifraud');

        $this->_blockGroup = 'awardit_antifraud';
        $this->_objectId = 'id';
        $this->_controller = 'rule';

        parent::__construct();

        $this->_updateButton('save', 'label', $this->helper->__('Save fraud rule'));
        $this->_updateButton('delete', 'label', $this->helper->__('Delete fraud rule'));
    }

    /**
     * Prepare layout, add warning if relevant.
     * @return Mage_Core_Block_Abstract
     */
    protected function _prepareLayout(): Mage_Core_Block_Abstract
    {
        if (!$this->helper->hasCurrencyRates()) {
            /** @var Mage_Core_Model_Layout $layout */
            $layout = $this->getLayout();
            /** @var Mage_Core_Block_Abstract $messages */
            $messages = $layout->createBlock('core/messages', 'messages');
            $this->setChild('antifraud-messages', $messages);
            $url = $this->getUrl('adminhtml/system_currency');
            $msg = 'One or more currencies have no currency rate defined. '
                 . 'Rules based on order value may not work as expected unless currency rates are defined. '
                 . 'Define rates <a href="%s">here</a>.';
            $messages->addWarning($this->helper->__($msg, $url));
        }
        return parent::_prepareLayout();
    }

    /**
     * Get header text.
     * @return string The header.
     */
    public function getHeaderText(): string
    {
        if (Mage::registry('rule')->exists()) {
            return $this->helper->__('Edit fraud rule');
        } else {
            return $this->helper->__('New fraud rule');
        }
    }

    /**
     * Set type.
     * @param string $type Type.
     * @return $this
     */
    public function setClassType(string $type): self
    {
        $this->getChild('form')->setClassType($type);
        return $this;
    }
}
