<?php

/**
 * Ensure columns in database.
 */

$installer = $this;

$conn = $installer->getConnection();
$table = $installer->getTable('awardit_antifraud/order');
$ddl = $conn->describeTable($table);

if (!array_key_exists('risk_recommendation', $ddl)) {
    $conn->addColumn($table, 'risk_recommendation', [
        'type' => Varien_Db_Ddl_Table::TYPE_TEXT,
        'length' => 32,
        'nullable' => true,
        'comment' => 'Risk recommendation'
    ]);
}
if (!array_key_exists('risk_score', $ddl)) {
    $conn->addColumn($table, 'risk_score', [
        'type' => Varien_Db_Ddl_Table::TYPE_INTEGER,
        'nullable' => true,
        'unsigned' => true,
        'comment' => 'Risk score'
    ]);
}
