<?php

/**
 * Ensure columns in database.
 */

$installer = $this;

$conn = $installer->getConnection();
$item_table = $installer->getTable('awardit_antifraud/order_item');
$rule_table = $installer->getTable('awardit_antifraud/rule');

$ddl = $conn->describeTable($item_table);

if (!array_key_exists('money_paid', $ddl)) {
    $conn->addColumn($item_table, 'money_paid', [
        'type' => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        'length' => '12,4',
        'nullable' => false,
        'default' => '0',
        'comment' => 'Money paid'
    ]);
}
if (!array_key_exists('discount_used', $ddl)) {
    $conn->addColumn($item_table, 'discount_used', [
        'type' => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        'length' => '12,4',
        'nullable' => false,
        'default' => '0',
        'comment' => 'Discount amount'
    ]);
}
if (!array_key_exists('item_value', $ddl)) {
    $conn->addColumn($item_table, 'item_value', [
        'type' => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        'length' => '12,4',
        'nullable' => false,
        'default' => '0',
        'comment' => 'Item value'
    ]);
}

$ddl = $conn->describeTable($rule_table);

if (!array_key_exists('item_value', $ddl)) {
    $conn->addColumn($rule_table, 'sku_filter', [
        'type' => Varien_Db_Ddl_Table::TYPE_TEXT,
        'length' => 32,
        'nullable' => false,
        'default' => '',
        'comment' => 'SKU filter'
    ]);
}
