<?php

/**
 * Add column and populate it.
 */

$installer = $this;

$conn = $installer->getConnection();
$item_table = $installer->getTable('awardit_antifraud/order_item');
$rule_table = $installer->getTable('awardit_antifraud/rule');

$conn->addColumn($item_table, 'money_paid', [
    'type' => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    'length' => '12,4',
    'nullable' => false,
    'default' => '0',
    'comment' => 'Money paid'
]);
$conn->addColumn($item_table, 'discount_used', [
    'type' => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    'length' => '12,4',
    'nullable' => false,
    'default' => '0',
    'comment' => 'Discount amount'
]);
$conn->addColumn($item_table, 'item_value', [
    'type' => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    'length' => '12,4',
    'nullable' => false,
    'default' => '0',
    'comment' => 'Item value'
]);
$conn->addColumn($rule_table, 'sku_filter', [
    'type' => Varien_Db_Ddl_Table::TYPE_TEXT,
    'length' => 32,
    'nullable' => false,
    'default' => '',
    'comment' => 'SKU filter'
]);
