<?php

class Awardit_Antifraud_Model_Order_Item extends Mage_Core_Model_Abstract
{
    /**
     * Initialize object.
     */
    protected function _construct(): void
    {
        $this->_init('awardit_antifraud/order_item');
    }

    /**
     * If entry exists in database.
     * @return bool If entry exists in database.
     */
    public function exists(): bool
    {
        return !is_null($this->getId());
    }

    /**
     * Index order for future fraud evaluation.
     * @param Mage_Sales_Model_Order_Item $item Order item instance.
     */
    public function indexOrderItem(
        Mage_Sales_Model_Order_Item $item,
        float $rate
    ): void {
        $helper = Mage::helper('awardit_antifraud');
        if (!$orderItemId = $item->getId()) {
            return; // Not stored yet
        }
        $this->load($orderItemId);
        $this->setData([
            'orderitem_id' => $item->getId(),
            'order_id' => $item->getOrderId(),
            'store_id' => $item->getStoreId(),
            'sku' => $item->getSku(),
            'qty' => $helper->resolveQty($item),
            'money_paid' => $helper->resolveMoneyPaid($item, $rate),
            'discount_used' => round($item->getBaseDiscountAmount(), 4),
            'item_value' => $helper->resolveValue($item, $rate),
        ]);
        $this->save();
    }
}
