<?php

/**
 * Controller for Sales > Fraud management > Blacklist page.
 */
class Awardit_Antifraud_Adminhtml_Antifraud_BlacklistController extends Mage_Adminhtml_Controller_Action
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    public function __construct(
        Zend_Controller_Request_Abstract $request,
        Zend_Controller_Response_Abstract $response,
        array $invokeArgs = []
    ) {
        $this->helper = Mage::helper('awardit_antifraud');
        parent::__construct($request, $response, $invokeArgs);
    }

    /**
     * List of blacklist entries.
     */
    public function indexAction(): void
    {
        /** @var Awardit_Antifraud_Block_Blacklist */
        $block = $this->getLayout()->createBlock('awardit_antifraud/blacklist');
        $this->_initAction()
            ->_addContent($block)
            ->renderLayout();
    }

    /**
     * Editor for an existing blacklist entry.
     */
    public function editAction(): void
    {
        $uid = $this->getRequest()->getParam('id');
        $blacklist = Mage::getModel('awardit_antifraud/blacklist')->load($uid);
        $this->_initAction();
        if ($blacklist->exists()) {
            Mage::register('blacklist', $blacklist);
            /** @var Awardit_Antifraud_Block_Blacklist_Edit */
            $block = $this->getLayout()->createBlock('awardit_antifraud/blacklist_edit');
            $this->_addContent(
                $block
                    ->assign('header',$this->helper->__('Edit entry'))
                    ->assign('form', $this->getLayout()->createBlock('awardit_antifraud/blacklist_edit_form'))
            )->renderLayout();
        } else {
            Mage::getSingleton('adminhtml/session')->addError($this->helper->__('Item does not exist'));
            $this->_redirect('*/*/');
        }
    }

    /**
     * Editor for a new blacklist entry.
     */
    public function newAction(): void
    {
        $blacklist = Mage::getModel('awardit_antifraud/blacklist');
        Mage::register('blacklist', $blacklist);
        $this->_initAction();
        /** @var Awardit_Antifraud_Block_Blacklist_Edit */
        $block = $this->getLayout()->createBlock('awardit_antifraud/blacklist_edit');
        $this->_addContent(
            $block
                ->assign('header',$this->helper->__('New entry'))
                ->assign('form', $this->getLayout()->createBlock('awardit_antifraud/blacklist_edit_form'))
        )->renderLayout();
    }

    /**
     * Saving new or existing blacklist entry.
     */
    public function saveAction(): void
    {
        $this->helper = Mage::helper('awardit_antifraud');
        $request = $this->getRequest()->getPost();
        $model = Mage::getModel('awardit_antifraud/blacklist');
        $uid = $this->getRequest()->getParam('id');

        if ($this->getRequest()->getPost()) {
            try {
                $model->load($uid);

                if (!$model->exists()) {
                    $model->setCreatedAt(date('c'));
                }
                $model->setStoreId($request['store_id']);
                $model->setType($request['type']);
                $model->setValue($request['value']);
                $model->setMode($request['mode']);
                $model->save();

                Mage::getSingleton('adminhtml/session')->addSuccess($this->helper->__('Successfully saved.'));
                Mage::getSingleton('adminhtml/session')->setData('antifraud.blacklist', false);

            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($this->helper->__('Invalid data provided.'));
                Mage::getSingleton('adminhtml/session')->setData('antifraud.blacklist', $request);
                if ($model->exists()) {
                    $this->_redirect('*/*/edit', ['id' => $uid]);
                } else {
                    $this->_redirect('*/*/new');
                }
                return;
            }
        }
        $this->_redirect('*/*/');
    }

    /**
     * Delete an existing blacklist entry.
     */
    public function deleteAction(): void
    {
        $uid = $this->getRequest()->getParam('id');
        $blacklist = Mage::getModel('awardit_antifraud/blacklist')->load($uid);
        $this->_initAction();

        if ($blacklist->exists()) {
            try {
                $blacklist->delete();
                Mage::getSingleton('adminhtml/session')->addSuccess($this->helper->__('Item was successfully deleted'));
                $this->_redirect('*/*/');
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                $this->_redirect('*/*/edit', ['id' => $uid]);
            }
        }
        $this->_redirect('*/*/');
    }

    /**
     * Init helper method.
     * @return $this
     */
    protected function _initAction(): self
    {
        $this->_title($this->__('Sales'))
             ->_title($this->__('Fraud management'))
             ->_title($this->__('Blacklist'));

        $this->loadLayout()
            ->_setActiveMenu('sales/antifraud/blacklist')
            ->_addBreadcrumb($this->helper->__('Fraud management'), $this->helper->__('Fraud management'))
            ->_addBreadcrumb($this->helper->__('Blacklist'), $this->helper->__('Blacklist'))
        ;
        return $this;
    }
}
