<?php

class Awardit_Antifraud_Model_Result
{
    /** @var array<array-key, array> */
    private $list = [
        Awardit_Antifraud_ResolverInterface::DENY => [],
        Awardit_Antifraud_ResolverInterface::HOLD => [],
        Awardit_Antifraud_ResolverInterface::ALERT => [],
        Awardit_Antifraud_ResolverInterface::ALLOW => []
    ];

    /**
     * Append Blacklist or Fraud rule to result accumulator.
     * @param Awardit_Antifraud_ResolverInterface $resolved Blacklist or Fraud rule.
     * @return $this
     */
    public function append(Awardit_Antifraud_ResolverInterface $resolved): self
    {
        $this->list[$resolved->getMode()][] = $resolved;
        return $this;
    }

    /**
     * Merge another result into this.
     * @param self $result Result to merge.
     * @return $this
     */
    public function merge(self $result): self
    {
        $this->list = array_merge_recursive($this->list, $result->list);
        return $this;
    }

    /**
     * Get accumulated result mode, priority: allow, deny, hold, alert.
     * @return string Accumulated result.
     */
    public function getMode(): string
    {
        if (!empty($this->list[Awardit_Antifraud_ResolverInterface::ALLOW])) {
            return Awardit_Antifraud_ResolverInterface::ALLOW ;
        }
        if (!empty($this->list[Awardit_Antifraud_ResolverInterface::DENY])) {
            return Awardit_Antifraud_ResolverInterface::DENY;
        }
        if (!empty($this->list[Awardit_Antifraud_ResolverInterface::HOLD])) {
            return Awardit_Antifraud_ResolverInterface::HOLD;
        }
        if (!empty($this->list[Awardit_Antifraud_ResolverInterface::ALERT])) {
            return Awardit_Antifraud_ResolverInterface::ALERT;
        }
        return 'ok';
    }

    /**
     * Get all appended resolvers.
     * @return array<Awardit_Antifraud_ResolverInterface> Resolver list.
     */
    public function getResolved(): array
    {
        return array_merge(...array_values($this->list));
    }

    /**
     * Get list of resolver descriptions.
     * @param string $prefix Prefix for description entry.
     * @return array<string> Description list.
     */
    public function getDescriptionList(string $prefix = ''): array
    {
        return array_map(function ($item) use ($prefix) {
            return "{$prefix}{$item->describe()}";
        }, $this->getResolved());
    }
}
