<?php

/**
 * Add column and populate it.
 */

$installer = $this;

$conn = $installer->getConnection();
$order_table = $installer->getTable('awardit_antifraud/order');
$status_table = $installer->getTable('sales/order_status_state');

$conn->modifyColumn($order_table, 'created_at', [
    'type' => Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
    'nullable' => false,
    'comment' => 'Created at'
]);
$conn->addColumn($order_table, 'order_state', [
    'type' => Varien_Db_Ddl_Table::TYPE_TEXT,
    'length' => 32,
    'nullable' => true,
    'default' => null,
    'comment'   => 'Order state'
]);

$conn->addIndex(
    $order_table,
    $installer->getIdxName(
        'awardit_antifraud/order',
        [
            'store_id',
            'order_state',
            'ip',
            'created_at',
        ]
    ),
    [
        'store_id',
        'order_state',
        'ip',
        'created_at',
    ],
    Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
);
$conn->addIndex(
    $order_table,
    $installer->getIdxName(
        'awardit_antifraud/order',
        [
            'store_id',
            'order_state',
            'email_user_hash',
            'created_at',
        ]
    ),
    [
        'store_id',
        'order_state',
        'email_user_hash',
        'created_at',
    ],
    Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
);
$conn->addIndex(
    $order_table,
    $installer->getIdxName(
        'awardit_antifraud/order',
        [
            'store_id',
            'order_state',
            'email_domain',
            'created_at',
        ]
    ),
    [
        'store_id',
        'order_state',
        'email_domain',
        'created_at',
    ],
    Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
);
$conn->dropIndex($order_table, $installer->getIdxName(
    'awardit_antifraud/order',
    [
        'store_id',
        'ip',
        'created_at',
    ]
));
$conn->dropIndex($order_table, $installer->getIdxName(
    'awardit_antifraud/order',
    [
        'store_id',
        'email_user_hash',
        'created_at',
    ]
));
$conn->dropIndex($order_table, $installer->getIdxName(
    'awardit_antifraud/order',
    [
        'store_id',
        'email_domain',
        'created_at',
    ]
));

$installer->run("UPDATE {$order_table} aao LEFT JOIN {$status_table} soss ON (soss.status=aao.order_status) SET order_state=soss.state;");

$installer->endSetup();
