<?php

class Awardit_Antifraud_Model_Blacklist extends Mage_Core_Model_Abstract implements Awardit_Antifraud_ResolverInterface
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    /**
     * Initialize object.
     */
    protected function _construct(): void
    {
        $this->helper = Mage::helper('awardit_antifraud');
        $this->_init('awardit_antifraud/blacklist');
    }

    /**
     * If entry exists in database.
     * @return bool If entry exists in database.
     */
    public function exists(): bool
    {
        return !is_null($this->getId());
    }

    /**
     * Get mode.
     * @return string Mode of this instance.
     */
    public function getMode(): string
    {
        return (string)$this->getData('mode');
    }

    /**
     * Resolve mode for Quote or Order instance.
     * @param Mage_Sales_Model_Order|Mage_Sales_Model_Quote $model Instance to resolve.
     * @return Awardit_Antifraud_Model_Result Result accumulator.
     */
    public function getResolved(Mage_Core_Model_Abstract $model): Awardit_Antifraud_Model_Result
    {
        $ip = $this->helper->resolveIpAddr($model);
        $email = trim($model->getCustomerEmail());
        $result = new Awardit_Antifraud_Model_Result();

        $collection = $this->getCollection();
        $select = $collection->getSelect();
        $select->where("(store_id = {$model->getStoreId()} OR store_id = 0)");
        $select->where("((type = 'ip' AND '{$ip}' LIKE value) OR (type = 'email' AND '{$email}' LIKE value))");
        $select->order(new Zend_Db_Expr("mode='allow' DESC, mode='deny' DESC, mode='hold' DESC"));
        $select->limit(1);

        // If match, apply blacklist
        if ($blacklist = $collection->fetchItem()) {
            $result->append($blacklist);
        }
        return $result;
    }

    /**
     * Describe application.
     * @return string Description.
     */
    public function describe(): string
    {
        $modes = $this->helper->getModeOptions();
        $types = $this->helper->getTypeOptions();
        return "Blacklist {$modes[$this->getMode()]}: {$types[$this->getType()]} = {$this->getValue()}";
    }
}
