<?php

class Awardit_Antifraud_Model_Order_Item extends Mage_Core_Model_Abstract
{
    /**
     * Initialize object.
     */
    protected function _construct(): void
    {
        $this->_init('awardit_antifraud/order_item');
    }

    /**
     * If entry exists in database.
     * @return bool If entry exists in database.
     */
    public function exists(): bool
    {
        return !is_null($this->getId());
    }

    /**
     * Index order for future fraud evaluation.
     * @param Mage_Sales_Model_Order_Item $item Order item instance.
     * @return $this
     */
    public function indexOrderItem(Mage_Sales_Model_Order_Item $item): self
    {
        $this->load($item->getId());
        $this->setData([
            'orderitem_id' => $item->getId(),
            'order_id' => $item->getOrderId(),
            'store_id' => $item->getStoreId(),
            'sku' => $item->getSku(),
            'qty' => $item->getQtyOrdered(),
        ]);
        return $this->save();
    }
}
