<?php

class Awardit_Antifraud_Block_Rule_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    /**
     * Constructor for Fraud rule Form block.
     */
    public function __construct()
    {
        parent::__construct();
        $this->helper = Mage::helper('awardit_antifraud');
        $this->setId('antifraudRuleForm');
    }

    /**
     * Field register for Fraud rule Form block.
     * @return $this
     */
    protected function _prepareForm(): self
    {
        $model = Mage::registry('rule');

        $form = new Varien_Data_Form([
            'id'        => 'edit_form',
            'action'    => $this->getData('action'),
            'method'    => 'post'
        ]);

        $this->setTitle($this->helper->__('Fraud rule'));
        $fieldset = $form->addFieldset('base_fieldset', [
            'legend' => $this->helper->__('Fraud rule')
        ]);

        $fieldset->addField('store_id', 'select', [
            'name'  => 'store_id',
            'label' => $this->helper->__('Store'),
            'value' => $model->getStoreId(),
            'options' => $this->helper->getStoreOptions(),
        ]);
        $fieldset->addField('rule_type', 'select', [
            'name'  => 'rule_type',
            'label' => $this->helper->__('Rule type'),
            'value' => $model->getRuleType(),
            'options' => $this->helper->getRuleTypeOptions(),
        ]);
        $fieldset->addField('rule_value', 'text', [
            'name'  => 'rule_value',
            'label' => $this->helper->__('Rule value'),
            'class' => 'required-entry',
            'value' => $model->getRuleValue(),
            'required' => true,
        ]);
        $fieldset->addField('group_type', 'select', [
            'name'  => 'group_type',
            'label' => $this->helper->__('Group type'),
            'value' => $model->getGroupType(),
            'options' => $this->helper->getGroupTypeOptions(),
        ]);
        $fieldset->addField('group_interval', 'select', [
            'name'  => 'group_interval',
            'label' => $this->helper->__('Group time interval'),
            'value' => $model->getGroupInterval(),
            'options' => $this->helper->getGroupIntervalOptions(),
        ]);
        $fieldset->addField('mode', 'select', [
            'name'  => 'mode',
            'label' => $this->helper->__('Mode'),
            'value' => $model->getMode(),
            'options' => $this->helper->getModeOptions(),
        ]);

        if ($model->exists()) {
            $fieldset->addField('rule_id', 'hidden', [
                'name'      => 'id',
                'value'     => $model->getId(),
                'no_span'   => true
            ]);
        }

        $form->setAction($this->getUrl('*/*/save'));
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
