<?php

class Awardit_Antifraud_Model_Order extends Mage_Core_Model_Abstract
{
    /**
     * Initialize object.
     */
    protected function _construct(): void
    {
        $this->_init('awardit_antifraud/order');
    }

    /**
     * If entry exists in database.
     * @return bool If entry exists in database.
     */
    public function exists(): bool
    {
        return !is_null($this->getId());
    }

    /**
     * Index order for future fraud evaluation.
     * @param Mage_Sales_Model_Order $order Order instance.
     * @return $this
     */
    public function indexOrder(Mage_Sales_Model_Order $order): self
    {
        $helper = Mage::helper('awardit_antifraud');
        $this->load($order->getId());
        $payment = $order->getPayment();

        $this->setData([
            'order_id' => $order->getId(),
            'increment_id' => $order->getIncrementId(),
            'store_id' => $order->getStoreId(),
            'order_status' => $order->getStatus(),
            'ip' => $helper->resolveIpAddr($order),
            'email_user_hash' => $helper->resolveEmailUserHash($order),
            'email_domain' => $helper->resolveEmailDomain($order),
            'money_paid' => $payment->getData('base_amount_paid') ?? $payment->getData('base_amount_authorized'),
            'points_paid' => floatval($order->getData('points_points') + $order->getData('points_tax_points')),
            'discount_used' => floatval($order->getData('base_retain24_amount') + $order->getData('base_discount_amount')),
            'order_value' => $order->getBaseGrandTotal() * $order->getBaseToGlobalRate(),
            'created_at' => $order->getCreatedAt(),
            'order_state' => $order->getState(),
        ]);
        $this->save();

        foreach ($order->getItemsCollection() as $item) {
            $af_item = Mage::getModel('awardit_antifraud/order_item');
            $af_item->indexOrderItem($item);
        }
        return $this;
    }
}
