<?php

class Awardit_Antifraud_Block_Rule extends Mage_Adminhtml_Block_Widget_Grid_Container
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    /**
     * Constructor for Fraud rule List block.
     */
    public function __construct()
    {
        $this->helper = Mage::helper('awardit_antifraud');
        $this->_blockGroup = 'awardit_antifraud';
        $this->_controller = 'rule';
        $this->_headerText = $this->helper->__('Fraud rules');
        $this->_addButtonLabel = $this->helper->__('Add fraud rule');
        parent::__construct();
    }

    /**
     * Prepare layout, add warning if relevant.
     * @return $this
     */
    protected function _prepareLayout(): self
    {
        if (!$this->helper->hasCurrencyRates()) {
            $messages = $this->getLayout()->createBlock('core/messages', 'messages');
            $this->setChild('antifraud-messages', $messages);
            $url = $this->getUrl('adminhtml/system_currency');
            $msg = 'One or more currencies have no currency rate defined. '
                 . 'Rules based on order value may not work as expected unless currency rates are defined. '
                 . 'Define rates <a href="%s">here</a>.';
            $messages->addWarning($this->helper->__($msg, $url));
        }
        return parent::_prepareLayout();
    }
}
