<?php

class Awardit_Antifraud_Block_Blacklist_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    /**
     * Constructor for Blacklist Form block.
     */
    public function __construct()
    {
        parent::__construct();
        $this->helper = Mage::helper('awardit_antifraud');
        $this->setId('antifraudBlacklistForm');
    }

    /**
     * Field register for Blacklist Form block.
     * @return $this
     */
    protected function _prepareForm(): self
    {
        $model = Mage::registry('blacklist');

        $form = new Varien_Data_Form([
            'id'        => 'edit_form',
            'action'    => $this->getData('action'),
            'method'    => 'post'
        ]);

        $this->setTitle($this->helper->__('Blacklist'));
        $fieldset = $form->addFieldset('base_fieldset', [
            'legend' => $this->helper->__('Blacklist entry')
        ]);

        $fieldset->addField('store_id', 'select', [
            'name'  => 'store_id',
            'label' => $this->helper->__('Store'),
            'value' => $model->getStoreId(),
            'options' => $this->helper->getStoreOptions(),
        ]);
        $fieldset->addField('type', 'select', [
            'name'  => 'type',
            'label' => $this->helper->__('Type'),
            'value' => $model->getType(),
            'options' => $this->helper->getTypeOptions(),
        ]);
        $fieldset->addField('value', 'text', [
            'name'  => 'value',
            'label' => $this->helper->__('Value'),
            'class' => 'required-entry',
            'value' => $model->getValue(),
            'required' => true,
        ]);
        $fieldset->addField('mode', 'select', [
            'name'  => 'mode',
            'label' => $this->helper->__('Mode'),
            'note' => $this->helper->__('Not all payment methods support "Hold" mode. These will use "Alert" instead.'),
            'value' => $model->getMode(),
            'options' => $this->helper->getModeOptions(),
        ]);

        if ($model->exists()) {
            $fieldset->addField('blacklist_id', 'hidden', [
                'name'      => 'id',
                'value'     => $model->getId(),
                'no_span'   => true
            ]);
        }

        $form->setAction($this->getUrl('*/*/save'));
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
