<?php

/**
 * Installs database table for antifraud management.
 */

$installer = $this;

$conn = $installer->getConnection();

$blacklist_table = $conn->newTable($installer->getTable('awardit_antifraud/blacklist'))
    ->addColumn('blacklist_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'identity'  => true,
        'unsigned'  => true,
        'nullable'  => false,
        'primary'   => true,
    ], 'Unique id')
    ->addColumn('store_id', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Store id')
    ->addColumn('type', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Check type')
    ->addColumn('value', Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
        'nullable'  => false,
    ], 'Check value')
    ->addColumn('mode', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Action mode')
    ->addColumn('created_at', Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        'nullable'  => false,
        'default'   => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/blacklist',
            'store_id',
            'core/store',
            'store_id'
        ),
        'store_id',
        $installer->getTable('core/store'),
        'store_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_antifraud/blacklist',
            [
                'store_id',
                'type',
                'value',
            ]
        ),
        [
            'store_id',
            'type',
            'value',
        ],
        Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
    )
    ->setOption('type', 'InnoDB')
    ->setOption('charset', 'utf8mb4')
    ->setOption('collate', 'utf8mb4_general_ci');

$conn->createTable($blacklist_table);

$rule_table = $conn->newTable($installer->getTable('awardit_antifraud/rule'))
    ->addColumn('rule_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'identity'  => true,
        'unsigned'  => true,
        'nullable'  => false,
        'primary'   => true,
    ], 'Unique id')
    ->addColumn('store_id', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Store id')
    ->addColumn('rule_type', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Rule type')
    ->addColumn('rule_value', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Rule value')
    ->addColumn('group_type', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Group type')
    ->addColumn('group_interval', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Group timerange')
    ->addColumn('mode', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Action mode')
    ->addColumn('created_at', Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        'nullable'  => false,
        'default'   => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/rule',
            'store_id',
            'core/store',
            'store_id'
        ),
        'store_id',
        $installer->getTable('core/store'),
        'store_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_antifraud/rule',
            [
                'store_id',
            ]
        ),
        [
            'store_id',
        ],
        Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
    )
    ->setOption('type', 'InnoDB')
    ->setOption('charset', 'utf8mb4')
    ->setOption('collate', 'utf8mb4_general_ci');

$conn->createTable($rule_table);

$order_table = $conn->newTable($installer->getTable('awardit_antifraud/order'))
    ->addColumn('order_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => false,
        'primary'   => true,
    ], 'Unique id')
    ->addColumn('increment_id', Varien_Db_Ddl_Table::TYPE_TEXT, 50, [
        'nullable'  => true,
    ], 'Order id')
    ->addColumn('store_id', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Store id')
    ->addColumn('order_status', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Order status')
    ->addColumn('ip', Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
        'nullable'  => false,
    ], 'Remote IP-adress')
    ->addColumn('email_user_hash', Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
        'nullable'  => false,
    ], 'Email hash')
    ->addColumn('email_domain', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Email domain')
    ->addColumn('money_paid', Varien_Db_Ddl_Table::TYPE_DECIMAL, '12,4', [
        'nullable'  => false,
        'unsigned'  => true,
        'default'   => '0',
    ], 'Money paid')
    ->addColumn('points_paid', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'nullable'  => false,
        'unsigned'  => true,
        'default'   => '0',
    ], 'Points paid')
    ->addColumn('discount_used', Varien_Db_Ddl_Table::TYPE_DECIMAL, '12,4', [
        'nullable'  => false,
    ], 'Discount amount')
    ->addColumn('order_value', Varien_Db_Ddl_Table::TYPE_DECIMAL, '12,4', [
        'nullable'  => false,
        'unsigned'  => true,
        'default'   => '0',
    ], 'Order total value')
    ->addColumn('created_at', Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        'nullable'  => false,
    ])
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/order',
            'store_id',
            'core/store',
            'store_id'
        ),
        'store_id',
        $installer->getTable('core/store'),
        'store_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/order',
            'order_id',
            'sales/order',
            'entity_id'
        ),
        'order_id',
        $installer->getTable('sales/order'),
        'entity_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_antifraud/order',
            [
                'store_id',
                'ip',
                'created_at',
            ]
        ),
        [
            'store_id',
            'ip',
            'created_at',
        ],
        Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_antifraud/order',
            [
                'store_id',
                'email_user_hash',
                'created_at',
            ]
        ),
        [
            'store_id',
            'email_user_hash',
            'created_at',
        ],
        Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_antifraud/order',
            [
                'store_id',
                'email_domain',
                'created_at',
            ]
        ),
        [
            'store_id',
            'email_domain',
            'created_at',
        ],
        Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
    )
    ->setOption('type', 'InnoDB')
    ->setOption('charset', 'utf8mb4')
    ->setOption('collate', 'utf8mb4_general_ci');

$conn->createTable($order_table);

$orderitem_table = $conn->newTable($installer->getTable('awardit_antifraud/order_item'))
    ->addColumn('orderitem_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => false,
        'primary'   => true,
    ], 'Unique id')
    ->addColumn('order_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Order id')
    ->addColumn('store_id', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Store id')
    ->addColumn('sku', Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        'nullable'  => true,
    ], 'Product SKU')
    ->addColumn('qty', Varien_Db_Ddl_Table::TYPE_DECIMAL, '12,4', [
        'nullable'  => false,
        'unsigned'  => true,
    ], 'Quantity')
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/order_item',
            'store_id',
            'core/store',
            'store_id'
        ),
        'store_id',
        $installer->getTable('core/store'),
        'store_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/order_item',
            'order_id',
            'awardit_antifraud/order',
            'order_id'
        ),
        'order_id',
        $installer->getTable('awardit_antifraud/order'),
        'order_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addForeignKey(
        $installer->getFkName(
            'awardit_antifraud/order_item',
            'orderitem_id',
            'sales/order_item',
            'item_id'
        ),
        'orderitem_id',
        $installer->getTable('sales/order_item'),
        'item_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_antifraud/order_item',
            [
                'store_id',
                'sku',
            ]
        ),
        [
            'store_id',
            'sku',
        ],
        Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
    )
    ->setOption('type', 'InnoDB')
    ->setOption('charset', 'utf8mb4')
    ->setOption('collate', 'utf8mb4_general_ci');

$conn->createTable($orderitem_table);

$installer->endSetup();
