<?php

class Awardit_Antifraud_Block_Rule_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
    /**
     * Constructor for Fraud rule Grid block.
     */
    public function __construct()
    {
        parent::__construct();
        $this->setDefaultSort('created_at');
        $this->setId('antifraudRuleGrid');
        $this->setDefaultDir('asc');
        $this->setSaveParametersInSession(true);
    }

    /**
     * Prepare grid collection.
     * @return $this
     */
    protected function _prepareCollection(): self
    {
        /** @var Awardit_Antifraud_Model_Resource_Rule_Collection $collection */
        $collection = Mage::getModel('awardit_antifraud/rule')->getCollection();
        $this->setCollection($collection);
        parent::_prepareCollection();
        return $this;
    }

    /**
     * Prepare grid columns.
     * @return $this
     */
    protected function _prepareColumns(): self
    {
        $helper = Mage::helper('awardit_antifraud');

        $this->addColumn('store_id', [
            'header' => $helper->__('Store'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'store_id',
            'type' => 'options',
            'options' => $helper->getStoreOptions(),
        ]);
        $this->addColumn('rule_type', [
            'header' => $helper->__('Rule type'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'rule_type',
            'type' => 'options',
            'options' => $helper->getRuleTypeOptions(),
        ]);
        $this->addColumn('rule_value', [
            'header' => $helper->__('Rule value'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'rule_value',
        ]);
        $this->addColumn('group_type', [
            'header' => $helper->__('Group type'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'group_type',
            'type' => 'options',
            'options' => $helper->getGroupTypeOptions(),
        ]);
        $this->addColumn('group_interval', [
            'header' => $helper->__('Group time interval'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'group_interval',
            'type' => 'options',
            'options' => $helper->getGroupIntervalOptions(),
        ]);
        $this->addColumn('mode', [
            'header' => $helper->__('Mode'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'mode',
            'type' => 'options',
            'options' => $helper->getModeOptions(),
        ]);
        $this->addColumn('created_at', [
            'header' => $helper->__('Created'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'created_at',
        ]);

        return parent::_prepareColumns();
    }

    /**
     * Return url.
     * @param Mage_Catalog_Model_Product|Varien_Object $row Item to get url for.
     * @return string Row Url.
     */
    public function getRowUrl($row): string
    {
        return $this->getUrl('*/*/edit', ['id' => $row->getId()]);
    }
}
