<?php

class Awardit_Antifraud_Block_Blacklist_Edit extends Mage_Adminhtml_Block_Widget_Form_Container
{
    /** @var Awardit_Antifraud_Helper_Data */
    private $helper;

    /**
     * Constructor for Blacklist Edit block.
     */
    public function __construct()
    {
        $this->helper = Mage::helper('awardit_antifraud');

        $this->_blockGroup = 'awardit_antifraud';
        $this->_objectId = 'id';
        $this->_controller = 'blacklist';

        parent::__construct();

        $this->_updateButton('save', 'label', $this->helper->__('Save blacklist entry'));
        $this->_updateButton('delete', 'label', $this->helper->__('Delete blacklist entry'));
    }

    /**
     * Get header text.
     * @return string The header.
     */
    public function getHeaderText(): string
    {
        if (Mage::registry('blacklist')->exists()) {
            return $this->helper->__('Edit blacklist entry');
        } else {
            return $this->helper->__('New blacklist entry');
        }
    }

    /**
     * Set type.
     * @param string $type.
     * @return self This instance.
     */
    public function setClassType(string $type): self
    {
        $this->getChild('form')->setClassType($type);
        return $this;
    }
}
