<?php

class Awardit_Antifraud_Block_Blacklist_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
    /**
     * Constructor for Blacklist Grid block.
     */
    public function __construct()
    {
        parent::__construct();
        $this->setDefaultSort('created_at');
        $this->setId('antifraudBlacklistGrid');
        $this->setDefaultDir('asc');
        $this->setSaveParametersInSession(true);
    }

    /**
     * Prepare grid collection.
     * @return $this
     */
    protected function _prepareCollection(): self
    {
        /** @var Awardit_Antifraud_Model_Resource_Blacklist_Collection $collection */
        $collection = Mage::getModel('awardit_antifraud/blacklist')->getCollection();
        $this->setCollection($collection);
        parent::_prepareCollection();
        return $this;
    }

    /**
     * Prepare grid columns.
     * @return $this
     */
    protected function _prepareColumns(): self
    {
        $helper = Mage::helper('awardit_antifraud');

        $this->addColumn('store_id', [
            'header' => $helper->__('Store'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'store_id',
            'type' => 'options',
            'options' => $helper->getStoreOptions(),
        ]);
        $this->addColumn('type', [
            'header' => $helper->__('Type'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'type',
            'type' => 'options',
            'options' => $helper->getTypeOptions(),
        ]);
        $this->addColumn('value', [
            'header' => $helper->__('Value'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'value',
        ]);
        $this->addColumn('mode', [
            'header' => $helper->__('Mode'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'mode',
            'type' => 'options',
            'options' => $helper->getModeOptions(),
        ]);
        $this->addColumn('created_at', [
            'header' => $helper->__('Created'),
            'sortable' => true,
            'align' => 'left',
            'index' => 'created_at',
        ]);

        return parent::_prepareColumns();
    }

    /**
     * Return url.
     * @param Mage_Catalog_Model_Product|Varien_Object $item Item to get url for.
     * @return string Row Url.
     */
    public function getRowUrl($item): string
    {
        return $this->getUrl('*/*/edit', ['id' => $item->getId()]);
    }
}
