<?php

/**
 * Used to create select source for order states.
 */
class Awardit_Antifraud_Model_Source_OrderState
{
    /**
     * Options getter.
     * @return array
     */
    public function toOptionArray(): array
    {
        $options = [];
        foreach ($this->toArray() as $key => $name) {
            $options[] = ['value' => $key, 'label' => $name];
        }
        return $options;
    }

    /**
     * Get options in "key-value" format.
     * @return array
     */
    public function toArray(): array
    {
        return Mage::getSingleton('sales/order_config')->getStates();
    }
}
