<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

class AntifraudCardTest extends TestCase
{
    public function setUp(): void {}

    public function testCardValidation(): void
    {
        $this->assertTrue(true);
        $card = new Awardit_Antifraud_Card_Antifraud([
            'header' => 'Antifraud alert from test',
            'mode' => 'An order has been evaluated for fraud with result: **Deny**.',
            'description' => [
                'header' => 'Check result',
                'facts' => [
                    [
                        'title' => 'Blacklist Deny:',
                        'value' => 'Email = john.doe_%@outlook.com'
                    ],
                    [
                        'title' => 'Fraud Alert:',
                        'value' => 'Order value (SEK) ≥ 4900 for Email username in 1 day'
                    ]
                ]
            ],
            'sale_info' => [
                'header' => 'Sale information',
                'facts' => [
                    [
                        'title' => 'Store',
                        'value' => 'Sponsorhuset SEK',
                    ],
                    [
                        'title' => 'Quote',
                        'value' => '123456',
                    ],
                    [
                        'title' => 'IP-address',
                        'value' => '2.2.2.2',
                    ],
                    [
                        'title' => 'Customer',
                        'value' => 'John Doe (john.doe@outlook.com)',
                    ],
                    [
                        'title' => 'Payment',
                        'value' => 'Walley Checkout',
                    ],
                ]
            ],
            'sender' => 'Magento 11',
        ]);

        $expected = <<<'JSON'
        {
            "contentType": "application\/vnd.microsoft.card.adaptive",
            "contentUrl": null,
            "content": {
                "type": "AdaptiveCard",
                "$schema": "http://adaptivecards.io/schemas/adaptive-card.json",
                "version": "1.5",
                "body": [
                    {
                        "type": "Container",
                        "style": "warning",
                        "bleed": true,
                        "items": [
                            {
                                "type": "TextBlock",
                                "size": "Medium",
                                "text": "Antifraud alert from test",
                                "wrap": true,
                                "weight": "Bolder"
                            }
                        ]
                    },
                    {
                        "type": "TextBlock",
                        "text": "An order has been evaluated for fraud with result: **Deny**.",
                        "wrap": true
                    },
                    {
                        "type": "TextBlock",
                        "text": "Check result",
                        "wrap": true,
                        "weight": "Bolder"
                    },
                    {
                        "type": "FactSet",
                        "facts": [
                            {
                                "title": "Blacklist Deny:",
                                "value": "Email = john.doe_%@outlook.com"
                            },
                            {
                                "title": "Fraud Alert:",
                                "value": "Order value (SEK) ≥ 4900 for Email username in 1 day"
                            }
                        ]
                    },
                    {
                        "type": "Container",
                        "items": [
                            {
                                "type": "TextBlock",
                                "text": "Sale information",
                                "wrap": true,
                                "weight": "Bolder"
                            },
                            {
                                "type": "FactSet",
                                "facts": [
                                    {
                                        "title": "Store",
                                        "value": "Sponsorhuset SEK"
                                    },
                                    {
                                        "title": "Quote",
                                        "value": "123456"
                                    },
                                    {
                                        "title": "IP-address",
                                        "value": "2.2.2.2"
                                    },
                                    {
                                        "title": "Customer",
                                        "value": "John Doe (john.doe@outlook.com)"
                                    },
                                    {
                                        "title": "Payment",
                                        "value": "Walley Checkout"
                                    }
                                ]
                            }
                        ],
                        "style": "warning",
                        "bleed": true
                    },
                    {
                        "type": "Container",
                        "style": "emphasis",
                        "bleed": true,
                        "items": [
                            {
                                "type": "TextBlock",
                                "text": "Magento 11",
                                "wrap": true,
                                "size": "Small",
                                "color": "Default",
                                "isSubtle": true
                            }
                        ]
                    }
                ]
            }
        }
        JSON;

        $renderedCard = $card->render();
        $this->assertEquals(json_decode($expected), $renderedCard);

        $result = $card->getValidator()->validate($renderedCard, $card->getSchema());
        $this->assertEmpty($result->error());
    }
}
