<?php

class Awardit_Antifraud_Model_Cron
{
    /**
     * Remove fraud order data over 1 year old.
     */
    public function cleanup(): void
    {
        $collection = Mage::getModel('awardit_antifraud/order')->getCollection();
        $collection->addFieldToFilter("created_at", ['lt' => new Zend_Db_Expr("DATE_SUB(NOW(), INTERVAL 1 YEAR)")]);
        $count = $collection->delete();
        Mage::helper('awardit_antifraud')->log("Deleted {$count} orders from fraud index.");
    }
}
