<?php

use Awardit\MicrosoftTeamsWebhook\Card\AdaptiveCard;

class Awardit_Antifraud_Card_Antifraud extends AdaptiveCard
{
    protected function renderBody(): array
    {
        $body = [];

        // Header
        $body[] = (object)[
            'type' => 'Container',
            'style' => 'warning',
            'bleed' => true,
            'items' => [(object)[
                'type' => 'TextBlock',
                'size' => 'Medium',
                'text' => $this->data['header'] ?? 'Antifraud alert',
                'wrap' => true,
                'weight' => 'Bolder',
            ]]
        ];

        // Mode
        $body[] = (object)[
            'type' => 'TextBlock',
            'text' => $this->data['mode'] ?? '',
            'wrap' => true,
        ];

        // Description
        $body[] = (object)[
            'type' => 'TextBlock',
            'text' => $this->data['description']['header'] ?? '',
            'wrap' => true,
            'weight' => 'Bolder',
        ];

        $body[] = (object)[
            'type' => 'FactSet',
            'facts' => isset($this->data['description']['facts'])
            ? $this->renderFact($this->data['description']['facts'])
            : [],
        ];

        // Sale info
        $sale_info = [(object)[
            'type' => 'TextBlock',
            'text' => $this->data['sale_info']['header'] ?? '',
            'wrap' => true,
            'weight' => 'Bolder',
        ]];
        $sale_info[] = (object)[
            'type' => 'FactSet',
            'facts' => isset($this->data['sale_info']['facts'])
                ? $this->renderFact($this->data['sale_info']['facts'])
                : [],
        ];

        $body[] = (object)[
            'type' => 'Container',
            'style' => 'warning',
            'bleed' => true,
            'items' => $sale_info,
        ];

        // Sender
        $body[] = (object)[
            'type' => 'Container',
            'style' => 'emphasis',
            'bleed' => true,
            'items' => [(object) [
                'type' => 'TextBlock',
                'text' => $this->data['sender'] ?? 'Magento Antifraud module',
                'wrap' => true,
                'size' => 'Small',
                'color' => 'Default',
                'isSubtle' => true,
            ]]
        ];

        return $body;
    }

    protected function renderFact(array $data): array
    {
        return array_map(function($item) {return (object)$item;}, $data);
    }
}