<?php

/**
 * @method string getEmailDomain()
 * @method string getIncrementId()
 */
class Awardit_Antifraud_Model_Order extends Mage_Core_Model_Abstract
{
    /**
     * Initialize object.
     */
    protected function _construct(): void
    {
        $this->_init('awardit_antifraud/order');
    }

    /**
     * If entry exists in database.
     * @return bool If entry exists in database.
     */
    public function exists(): bool
    {
        return !is_null($this->getId());
    }

    /**
     * Index order for future fraud evaluation.
     * @param Mage_Sales_Model_Order $order Order instance.
     * @return $this
     */
    public function indexOrder(Mage_Sales_Model_Order $order): self
    {
        $helper = Mage::helper('awardit_antifraud');
        if (!$orderId = $order->getId()) {
            return $this; // Not stored yet
        }
        $this->load($orderId);
        $rate = $order->getBaseToGlobalRate();
        $points = $order->getData('points_points') + $order->getData('points_tax_points');
        $discount = $order->getData('base_retain24_amount') + $order->getData('base_discount_amount');

        $this->setData([
            'order_id' => $order->getId(),
            'increment_id' => $order->getIncrementId(),
            'store_id' => $order->getStoreId(),
            'order_status' => $order->getStatus(),
            'ip' => $helper->resolveIpAddr($order),
            'email_user_hash' => $helper->resolveEmailUserHash($order),
            'email_domain' => $helper->resolveEmailDomain($order),
            'money_paid' => $helper->resolveMoneyPaid($order, $rate),
            'points_paid' => intval($points),
            'discount_used' => round($discount * $rate, 4),
            'order_value' => $helper->resolveValue($order, $rate),
            'created_at' => $order->getCreatedAt(),
            'order_state' => $order->getState(),
            'risk_recommendation' => $helper->resolveRiskRecommendation($order),
            'risk_score' => $helper->resolveRiskScore($order),
        ]);
        $this->save();

        foreach ($order->getAllVisibleItems() as $item) {
            $af_item = Mage::getModel('awardit_antifraud/order_item');
            $af_item->indexOrderItem($item, $rate);
        }
        return $this;
    }
}
