<?php

use GraphQL\Error\ClientAware;

class Awardit_Antifraud_Exception extends Mage_Core_Exception implements ClientAware
{
    /** @var string */
    protected $ruleGroup;

    /** @var string */
    protected $ruleType;

    public function __construct(string $message = '', string $ruleType = '', string $ruleGroup = '')
    {
        parent::__construct($message);
        $this->ruleGroup = $ruleGroup;
        $this->ruleType = $ruleType;
    }
    /**
     * Tells GraphQL that message should be shown to end user.
     * @return bool Always true.
     */
    public function isClientSafe(): bool
    {
        return true;
    }

    /**
     * GraphQL category.
     * @return string Category.
     */
    public function getCategory(): string
    {
        return 'antifraud';
    }

    /**
     * Rule group
     * @return string
     */
    public function getRuleGroup(): string
    {
        return $this->ruleGroup;
    }

    /**
     * Rule type
     * @return string
     */
    public function getRuleType(): string
    {
        return $this->ruleType;
    }
}
