<?php

use Psr\Http\Message\ResponseInterface;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * @extends Awardit_Altapay_Model_Checkout_Endpoint_BaseApi<null>
 */
class Awardit_Altapay_Model_Checkout_Endpoint_GetPaymentMethods extends Awardit_Altapay_Model_Checkout_Endpoint_BaseApi
{
    /** @var Awardit_Altapay_Model_Checkout_Configuration */
    protected $config;

    /** @var string */
    protected $sessionId;

    /**
     * @param Awardit_Altapay_Model_Checkout_Configuration $config
     */
    public function __construct(
        Awardit_Altapay_Model_Checkout_Configuration $config,
        string $sessionId
    ) {
        $this->config = $config;
        $this->sessionId = $sessionId;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return str_replace(['{sessionId}'], [$this->sessionId], '/checkout/v1/api/session/{sessionId}/payment-methods');
    }

    public function getHeaders(array $baseHeaders = []): array
    {
        $headers = ['Accept' => 'application/json', 'Content-Type' => 'application/json'];

        // this endpoint requires HTTP bearer token
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = sprintf('Bearer %s', $this->config->getAccessToken());
        }
        return array_merge($baseHeaders, $headers);
    }

    public function getBody(SerializerInterface $serializer): string
    {
        return '';
    }

    /**
     * @param ResponseInterface $response
     * @param SerializerInterface $serializer
     * @return null|Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse
     */
    public function parseResponse(ResponseInterface $response, SerializerInterface $serializer)
    {
        $status = $response->getStatusCode();
        $contentType = $response->hasHeader('Content-Type') ? current($response->getHeader('Content-Type')) : null;
        $body = (string) $response->getBody();

        if ($status === 200 && $contentType === 'application/json') {
            return $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse', 'json');
        }
        if ($status === 401 && $contentType === 'application/json') {
            throw new Awardit_Altapay_Model_Checkout_Exception_UnauthorizedException(
                'Unauthorized - missing or wrong JWT token.',
                $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_ErrorResponse', 'json')
            );
        }
        if ($status === 404 && $contentType === 'application/json') {
            throw new Awardit_Altapay_Model_Checkout_Exception_NotFoundException(
                'Session with given ID does not exist.',
                $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_ErrorResponse', 'json')
            );
        }
    }
}
