<?php

/*
 * Faking "verify" request from Altapay.
 * We don't know what this reeqest contains, below is assumptions.
 */
require_once __DIR__ . '/../vendor/autoload.php';

// Accepted input, with defaults.
$opt = array_merge([
    'host' => 'localhost',
    'sessionId' => '',
    'orderId' => '',
    'quoteId' => '',
], getopt('', [
    'host:',
    'sessionId:',
    'orderId:',
    'quoteId:',
]));

$body = [
    'sessionId' => $opt['sessionId'],
    'order' => [
        'orderId' => $opt['orderId'],
        'transactionInfo' => [
            'quoteId' => $opt['quoteId'],
        ],
        // More fields
    ],
];

$uri = "{$opt['host']}/Awardit_Altapay/callback/verify";
$client = new GuzzleHttp\Client();
try {
    $res = $client->request('POST', $uri, [
        'json' => $body,
    ]);
} catch (Throwable $e) {
    $res = $e->getResponse();
}

echo "\n\nRESULT: {$uri} {$res->getStatusCode()} {$res->getReasonPhrase()}\n";
echo "{$res->getBody()}\n";

