<?php

/**
 * @extends ArrayObject<array-key, mixed>
 * @psalm-suppress PossiblyUnusedProperty
 */
class Awardit_Altapay_Model_Type_NotificationCallback extends ArrayObject
{
    /** @var bool */
    public $requiresCapture = false;
    /** @var 'NEW'|'SUCCEEDED'|'ERROR'|'FAILED'|'PENDING'|'CANCELLED'|'DECLINED'|'UNKNOWN' */
    public $status = 'NEW';
    /** @var string */
    public $customerErrorMessage = '';
    /** @var string */
    public $merchantErrorCode = '';
    /** @var bool */
    public $customerMessageMustBeShown = false;
    /** @var array<string, mixed> */
    public $riskAnalysis = [];
    /** @var string */
    public $sessionId = '';
    /** @var array<string, mixed> */
    public $order = [];
    /** @var array<string, mixed> */
    public $cardInformation = [];
    /** @var array<string, mixed> */
    public $method = [];
    /** @var array<string, mixed> */
    public $agreement = [];
    /** @var array<string, mixed> */
    public $payment = [];

    public function __construct(array $data = array())
    {
        parent::__construct($data);
        foreach ($data as $key => $value) {
            $this->$key = $value;
        }
    }
}
