<?php

/**
 * @extends ArrayObject<array-key, mixed>
 * @psalm-suppress PossiblyUnusedProperty
 */
class Awardit_Altapay_Model_Checkout_Type_Payment extends ArrayObject
{
    /**
     * ID of the payment in Checkout API
     *
     * @var string
     */
    public $paymentId = '';
    /**
     * This is the internal ID of the order in your webshop
     *
     * @var string
     */
    public $shopOrderId = '';
    /**
    * The ID of the payment started by the customer in the payment gateway.
    * This value will be available once the payment process is started.
    * It will allow you to identify the payment in the payment gateway, query it for more information or
    * perform further actions like capture, refund, release, depending what is applicable for given payment.
    *
    * @var string
    */
    public $externalPaymentId = '';
    /**
     * The status of the transactions
     *
     * @var string
     */
    public $status = '';
    /**
     * Describes how to use URL to process payment
     *
     * @var array<string, mixed>
     */
    public $type = [];
    /**
     * URL to handle payment processing
     *
     * @var string
     */
    public $url = '';

    public function __construct(array $data = array())
    {
        parent::__construct($data);
        foreach ($data as $key => $value) {
            $this->$key = $value;
        }
    }
}
