<?php

use Psr\Log\LoggerInterface;

class Awardit_Altapay_Model_Api_Checkout
{
    /** @var Awardit_Altapay_Model_Checkout_Client */
    protected Awardit_Altapay_Model_Checkout_Client $client;

    /** @var Awardit_Altapay_Model_Checkout_Configuration */
    protected Awardit_Altapay_Model_Checkout_Configuration $config;

    public function __construct(
        ?Awardit_Altapay_Model_Checkout_Configuration $config = null,
        ?Awardit_Altapay_Model_Checkout_Client $client = null,
        ?LoggerInterface $logger = null
    ) {
        if (empty($config)) {
            $username = Mage::getStoreConfig('payment/altapay/username');
            $password = Mage::getStoreConfig('payment/altapay/password');
            $host = Mage::getStoreConfig('payment/altapay/host');
            $config = Awardit_Altapay_Model_Checkout_Configuration::create($username, $password, $host);
        }
        if (empty($client)) {
            $client = Awardit_Altapay_Model_Checkout_Client::create($config, null, $logger);
        }

        $this->client = $client;
        $this->config = $config;
    }
    /**
     * Altapay config
     * @return Awardit_Altapay_Model_Checkout_Configuration
     */
    public function getConfig(): Awardit_Altapay_Model_Checkout_Configuration
    {
        return $this->config;
    }

    /**
     * Check if client is authenticated
     * @return boolean
     */
    protected function isAuthenticated(): bool
    {
        if ($this->config->getAccessToken() === '') {
            return false;
        }

        // @todo check if token has expired
        return true;
    }

    /**
     * Get token
     * @param string $role
     * @param string|null $sessionId
     * @return Awardit_Altapay_Model_Checkout_Type_TokenResponse
     */
    public function authenticate(
        string $role,
        string $sessionId = null
    ): Awardit_Altapay_Model_Checkout_Type_TokenResponse {
        $request = new Awardit_Altapay_Model_Checkout_Type_AuthenticateRequest(array_filter([
            'role' => $role,
            'sessionId' => $sessionId,
        ]));
        return $this->client->authenticate($request);
    }

    /**
     * Altapay client that is authenticated
     * @return Awardit_Altapay_Model_Checkout_Client
     */
    public function getClient(): Awardit_Altapay_Model_Checkout_Client
    {
        if (!$this->isAuthenticated()) {
            $response = $this->authenticate('MERCHANT');
            $this->config->setAccessToken($response->token);
        }

        return $this->client;
    }
}
