<?php

namespace AltapayTests;

use Awardit_Altapay_Helper_Data;
use Awardit_Altapay_Model_Api_Checkout;
use Awardit_Altapay_Model_Api_Merchant;
use Awardit_Altapay_Model_Checkout_Client;
use Awardit_Altapay_Model_Checkout_Configuration;
use GuzzleHttp\Client;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Middleware;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class MockHelper
{
    /**
     * Get an Altapay helper with mock responses from Checkout api
     * @param array<array-key, mixed> $checkoutResponses
     * @param array<array-key, mixed> $checkoutRequests
     * @param array<array-key, mixed> $merchantResponses
     * @param array<array-key, mixed> $merchantRequests
     * @return Awardit_Altapay_Helper_Data
     * @psalm-suppress ReferenceConstraintViolation
     */
    public static function getHelper(
        array $checkoutResponses = [],
        array &$checkoutRequests = [],
        array $merchantResponses = [],
        array &$merchantRequests = []
    ): Awardit_Altapay_Helper_Data {
        // Create mocks and queue responses.
        $checkoutHandlerStack = HandlerStack::create(new MockHandler($checkoutResponses));
        $checkoutHandlerStack->push(Middleware::history($checkoutRequests));
        $merchantHandlerStack = HandlerStack::create(new MockHandler($merchantResponses));
        $merchantHandlerStack->push(Middleware::history($merchantRequests));

        $config = Awardit_Altapay_Model_Checkout_Configuration::create(
            'username',
            'password',
            'https://testgateway.altapaysecure.com'
        );

        $checkoutHttpClient = new Awardit_Altapay_Model_Checkout_Client(
            $config,
            new Client(['handler' => $checkoutHandlerStack, 'base_uri' => $config->getHost()]),
            new Serializer([new ObjectNormalizer()], [new JsonEncoder()])
        );
        $merchantHttpClient = new Client(['handler' => $merchantHandlerStack]);

        return new Awardit_Altapay_Helper_Data(
            new Awardit_Altapay_Model_Api_Checkout(
                $config,
                $checkoutHttpClient
            ),
            new Awardit_Altapay_Model_Api_Merchant($merchantHttpClient)
        );
    }
}
