<?php

class Awardit_Altapay_Model_Observer
{
    /**
     * If Quote is changed and assoicated with Altapay, update Altapay session.
     */
    public function onQuoteSave(Varien_Event_Observer $observer): void
    {
        $quote = $observer->getQuote();
        $payment = $quote->getPayment();
        if ($payment->getMethod() != 'altapay') {
            return;
        }
        $method = $payment->getMethodInstance();
        $method->updateSession($quote);
    }

    public function onMageqlContextCreateAfter(): void
    {
        $session = Mage::getSingleton('checkout/session');
        $quoteId = $session->getQuoteId();
        if (!$quoteId) {
            return;
        }
        $quote = Mage::getModel('sales/quote')->setStoreId(Mage::app()->getStore()->getId())->load($quoteId);
        if (!$quote->getId() || $quote->getPayment()->getMethod() != 'altapay') {
            return;
        }

        if ($quote->getIsActive()) {
            // Ensure quote in session
            $session->setQuoteId((int)$quote->getId());
            if ($session->getLastSuccessQuoteId() == $quote->getId()) {
                $session->setLastSuccessQuoteId(null);
            }
            return;
        }

        if (!$quote->getReservedOrderId()) {
            return;
        }

        $order = Mage::getModel('sales/order')->loadByIncrementId($quote->getReservedOrderId());
        if (!$order->getId()) {
            return;
        }

        $session->clear();
        if ($order->isCanceled()) {
            $session->setLastSuccessQuoteId(null);
        } else {
            $session->setLastSuccessQuoteId((int)$quote->getId());
        }
        $session->setLastOrderId((int)$order->getId());
        $session->setLastRealOrderId($order->getIncrementId());
    }
}
