<?php

/**
 * @extends ArrayObject<array-key, mixed>
 */
class Awardit_Altapay_Model_Checkout_Type_Session extends ArrayObject implements JsonSerializable
{
    /**
     * Unique session ID associated with user's checkout session
     *
     * @var string
     */
    public $sessionId = '';
    /**
     * Context of the checkout session
     *
     * @var array<string, mixed>
     */
    public $context = [];
    /**
     * Order details
     *
     * @var array<string, mixed>
     */
    public $order = [];
    /**
     * Callbacks associated with the checkout session that will be executed at different stages of the payment process
     *
     * @var array<string, mixed>
     */
    public $callbacks = [];
    /**
     * Configuration associated with the checkout session.
     *
     * @var array<string, mixed>
     */
    public $configuration = [];
    /**
     * Details of active payment associated with session.
     *
     * @var array<string, mixed>
     */
    public $activePayment = [];

    public function __construct(array $data = array())
    {
        parent::__construct($data);
        foreach ($data as $key => $value) {
            $this->$key = $value;
        }
    }

    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return (object)[
            'sessionId' => $this->sessionId,
            'context' => $this->context,
            'order' => $this->order,
            'callbacks' => $this->callbacks,
            'configuration' => $this->configuration,
            'activePayment' => $this->activePayment,
        ];
    }

    public function getInformation(): array
    {
        return [
            'session.activePayment.externalPaymentId' => $this->activePayment['externalPaymentId'] ?? null,
            'session.activePayment.paymentId' => $this->activePayment['paymentId'] ?? null,
            'session.activePayment.shopOrderId' => $this->activePayment['shopOrderId'] ?? null,
            'session.activePayment.status' => $this->activePayment['status'] ?? null,
            'session.order.amount.currency' => $this->order['amount']['currency'] ?? null,
            'session.order.amount.value' => $this->order['amount']['currency'] ?? null,
            'session.order.orderId' => $this->order['orderId'] ?? null,
            'session.order.transactionInfo.quoteId' => $this->order['transactionInfo']['quoteId'] ?? null,
            'session.order.transactionInfo.sessionToken' => $this->order['transactionInfo']['sessionToken'] ?? null,
            'session.order.transactionInfo.storeCode' => $this->order['transactionInfo']['storeCode'] ?? null,
            'session.sessionId' => $this->sessionId,
        ];
    }
}
