<?php

/**
 * Endpoint aware exception.
 * Need to be Mage_Core_Exception to show up properly in admin,
 * but also must be able to resolve as http error in webhook endpoints.
 */
class Awardit_Altapay_Exception extends Mage_Core_Exception
{
    public function __construct(string $message, int $code = 500, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public function getHttpMessage(): string
    {
        // Hide internal 500 errors
        return Mage::getIsDeveloperMode() || intdiv($this->code, 100) != 5
            ? $this->message
            : 'Server error';
    }
}
