<?php

use Fixtures\Customer;
use Fixtures\Discount;
use Fixtures\Order;
use Fixtures\Products;
use Fixtures\Shipping;
use Fixtures\TaxRates;
use Crossroads\Magento\Test\Integration\MagentoManager;

use function Fixtures\loadPoints;

error_reporting((E_ALL | E_STRICT) ^ E_DEPRECATED);

require_once __DIR__ . "/../vendor/autoload.php";
require_once __DIR__ . "/../vendor/crossroads/mageql/test/Fixtures/Customer.php";
require_once __DIR__ . "/../vendor/crossroads/mageql-catalog/test/Fixtures/Products.php";
require_once __DIR__ . "/../vendor/crossroads/mageql-catalog/test/Fixtures/TaxRates.php";
require_once __DIR__ . "/../vendor/crossroads/mageql-sales/test/Fixtures/Order.php";
require_once __DIR__ . "/../vendor/crossroads/mageql-sales/test/Fixtures/Shipping.php";
require_once __DIR__ . "/../vendor/crossroads/mageql-sales/test/Fixtures/Discount.php";
require_once __DIR__ . "/../vendor/crossroads/points-core/test/Fixtures/Points.php";

try {
    MagentoManager::setUp(__DIR__ . "/../vendor/awardit/magento-lts");

    (new Customer())->load();
    (new TaxRates())->load();
    (new Products())->load();
    (new Shipping())->load();
    (new Order())->load();
    loadPoints();
} catch (Throwable $t) {
    echo $t;

    throw $t;
}
