<?php

use PHPUnit\Framework\TestCase;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ArrayDenormalizer;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class PaymentMethodResponseNormalizerTest extends TestCase
{
    protected ?string $json;
    protected ?Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse $object;
    protected ?Serializer $serializer;

    public function setUp(): void
    {
        $this->json = file_get_contents(__DIR__ . '/../fixtures/paymentMethodResponse.json');

        $paymentMethod = new Awardit_Altapay_Model_Checkout_Type_PaymentMethod([
            "id" => "a28ff2fb-d932-4a1e-860d-7a5ec040b209",
            "type" => "CARD",
            "description" => "Credit / Debit Card",
            "logoUrl" => "https://testgateway.altapaysecure.com/checkout/static/methods/logos/creditcard-logo.png",
            "display" => "LIST",
            "onInitiatePayment" => [
                "type" => "URL",
                "value" => "https://testgateway.altapaysecure.com/checkout/v1/api/payment"
            ],
            "metadata" => [
                "canIssueNewCredit" => "false",
                "canUseCredit" => "true",
                "paymentType" => "PAYMENT",
                "shopName" => "Awardit",
                "terminalName" => "Awardit Credit Card Test Terminal"
            ],
            "name" => "Credit / Debit Card"
        ]);

        $this->object = new Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse();
        $this->object->methods = [$paymentMethod];

        $normalizers = [
            new ArrayDenormalizer(),
            new Awardit_Altapay_Model_Checkout_Normalizer_PaymentMethodResponseNormalizer(),
            new ObjectNormalizer(),
        ];
        $this->serializer = new Serializer($normalizers, [new JsonEncoder()]);
    }

    public function testDenormalizer(): void
    {
        /** @psalm-suppress PossiblyNullReference */
        $denom = $this->serializer->deserialize(
            $this->json,
            'Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse',
            'json'
        );
        $this->assertEquals($this->object, $denom);
    }

    public function testNormalizer(): void
    {
        /** @psalm-suppress PossiblyNullReference */
        $this->assertEquals($this->json, $this->serializer->serialize($this->object, 'json'));
    }
}
