<?php

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

/**
 * GraphQL operation class for Unzer.
 */
class Awardit_Altapay_Model_Graphql_Schema extends MageQL_Core_Model_Schema_Abstract
{
    /** @var Awardit_Altapay_Helper_Data */
    protected $helper;

    /**
     * Constructor for class.
     */
    public function __construct()
    {
        $this->helper = Mage::helper('awardit_altapay');
    }

    /**
     * Get Type builder or null.
     *
     * @param string $typeName
     * @param MageQL\Registry $registry
     *
     * @return null
     */
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder
    {
        return null;
    }

    /**
     * Get Type fields array.
     *
     * @param string $typeName
     * @param MageQL\Registry $registry
     * @return array<string, MageQL\Type\FieldBuilder|MageQL\Type\InputFieldBuilder>
     */
    public function getTypeFields(string $typeName, Registry $registry): array
    {
        switch ($typeName) {
            case 'Query':
                return [
                    "checkoutToken" => $this->field("String", "Altapay token")
                        ->addArgument("sessionId", $this->argument("String", "If we have a sessionId from Altapay"))
                        ->setResolver(function ($unusedSrc, array $args) {
                            $sessionId = $args['sessionId'] ?? null;
                            if ($sessionId !== null) {
                                $helper = Mage::helper('awardit_altapay');
                                return $helper->customerCheckoutToken($sessionId)->token;
                            }

                            $session = Mage::getSingleton("checkout/session");
                            $quote = $session->getQuote();

                            if ($quote->getId()) {
                                return $quote->getPayment()->getAdditionalInformation('checkoutToken');
                            }

                            $orderId = $session->getLastOrderId();

                            if (!$orderId) {
                                return null;
                            }

                            $order = Mage::getModel("sales/order");
                            $order->load($orderId);
                            $payment = $order->getPayment();

                            if ($order->getId() && $payment) {
                                return $payment->getAdditionalInformation('checkoutToken');
                            }

                            return null;
                        }),
                ];
        }
        return [];
    }
}
