<?php

use Psr\Http\Message\ResponseInterface;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * @extends Awardit_Altapay_Model_Checkout_Endpoint_BaseApi<Awardit_Altapay_Model_Checkout_Type_CreatePaymentRequest|null>
 */
class Awardit_Altapay_Model_Checkout_Endpoint_CreatePayment extends Awardit_Altapay_Model_Checkout_Endpoint_BaseApi
{
    /** @var Awardit_Altapay_Model_Checkout_Configuration */
    protected $config;

    /** @var Awardit_Altapay_Model_Checkout_Type_CreatePaymentRequest|null */
    protected $body;

    /**
     * @param Awardit_Altapay_Model_Checkout_Configuration $config
     */
    public function __construct(
        Awardit_Altapay_Model_Checkout_Configuration $config,
        ?Awardit_Altapay_Model_Checkout_Type_CreatePaymentRequest $requestBody = null
    ) {
        $this->config = $config;
        $this->body = $requestBody;
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function getUri(): string
    {
        return '/checkout/v1/api/payment';
    }

    public function getHeaders(array $baseHeaders = []): array
    {
        $headers = ['Accept' => 'application/json', 'Content-Type' => 'application/json'];

        // this endpoint requires HTTP bearer token
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = sprintf('Bearer %s', $this->config->getAccessToken());
        }
        return array_merge($baseHeaders, $headers);
    }

    public function getBody(SerializerInterface $serializer): string
    {
        return $serializer->serialize($this->body, 'json');
    }

    /**
     * @param ResponseInterface $response
     * @param SerializerInterface $serializer
     * @return null|Awardit_Altapay_Model_Checkout_Type_Payment
     */
    public function parseResponse(ResponseInterface $response, SerializerInterface $serializer)
    {
        $status = $response->getStatusCode();
        $contentType = $response->hasHeader('Content-Type') ? current($response->getHeader('Content-Type')) : null;
        $body = (string) $response->getBody();

        if ($status === 200 && $contentType === 'application/json') {
            return $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_Payment', 'json');
        }
        if ($status === 401 && $contentType === 'application/json') {
            throw new Awardit_Altapay_Model_Checkout_Exception_UnauthorizedException(
                'Unauthorized - missing or wrong JWT token.',
                $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_ErrorResponse', 'json')
            );
        }
        if ($status === 404 && $contentType === 'application/json') {
            throw new Awardit_Altapay_Model_Checkout_Exception_NotFoundException(
                'Session with given ID associated with payment request does not exist.',
                $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_ErrorResponse', 'json')
            );
        }
    }
}
