<?php

/*
 * Faking "notification" request from Altapay.
 */
require_once __DIR__ . '/../vendor/autoload.php';

// Accepted input, with defaults.
$opt = array_merge([
    'host' => 'localhost',
    'requiresCapture' => true,
    'status' => 'succeeded',
    'sessionId' => '',
    'orderId' => '',
    'amount' => 100,
], getopt('', [
    'host:',
    'requiresCapture:',
    'status:',
    'sessionId:',
    'orderId:',
    'amount:',
]));

$body = [
    'requiresCapture' => (bool)$opt['requiresCapture'],
    'status' => $opt['status'],
    'sessionId' => $opt['sessionId'],
    'merchantErrorMessage' => "Error message {$opt['status']}",
    'order' => [
        'orderId' => $opt['orderId'],
        'amount' => (float)$opt['amount'],
        // More fields
    ],
    'cardInformation' => [], // More fields
    'method' => [], // More fields
    'payment' => [
        'gateway' => [
            'publicPaymentId' => '52938521',
            'paymentId' => '04876da5-325f-4360-a9f0-0937d0925306',
        ],
    ], // More fields
];

$uri = "{$opt['host']}/Awardit_Altapay/callback/notification";
$client = new GuzzleHttp\Client();
try {
    $res = $client->request('POST', $uri, [
        'json' => $body,
    ]);
} catch (Throwable $e) {
    $res = $e->getResponse();
}
echo "\n\nRESULT: {$uri} {$res->getStatusCode()} {$res->getReasonPhrase()}\n";
echo "{$res->getBody()}\n";

