<?php

/**
 * @extends ArrayObject<array-key, mixed>
 * @psalm-suppress PossiblyUnusedProperty
 */
class Awardit_Altapay_Model_Checkout_Type_CreatePaymentRequest extends ArrayObject
{
    /**
     * Unique session ID for given customer's checkout session.
     *
     * @var string
     */
    public $sessionId = '';
    /**
     * Selected payment method ID
     *
     * @var string
     */
    public $paymentMethodId = '';
    /**
     * Flag indicating if the request comes from mobile device.
     *
     * @var bool
     */
    public $mobileDeviceRequest = false;

    public function __construct(array $data = array())
    {
        parent::__construct($data);
        foreach ($data as $key => $value) {
            $this->$key = $value;
        }
    }
}
