<?php

use Psr\Http\Message\ResponseInterface;
use Symfony\Component\Serializer\SerializerInterface;

interface Awardit_Altapay_Model_Checkout_Endpoint_Interface
{
    /**
     * Get body for an endpoint.
     */
    public function getBody(SerializerInterface $serializer): string;

    /**
     * Get the query string of an endpoint without the starting ? (like foo=foo&bar=bar).
     */
    public function getQueryString(): string;

    /**
     * Get the URI of an endpoint (like /foo-uri).
     */
    public function getUri(): string;

    /**
     * Get the HTTP method of an endpoint (like GET, POST, ...).
     */
    public function getMethod(): string;

    /**
     * Get the headers of an endpoint.
     */
    public function getHeaders(array $baseHeaders = []): array;

    /**
     * Parse and transform a PSR7 Response into a different object.
     * Implementations may vary depending the status code of the response and the fetch mode used.
     * @return mixed
     */
    public function parseResponse(ResponseInterface $response, SerializerInterface $serializer);
}
