<?php

/**
 * @extends ArrayObject<array-key, mixed>
 * @psalm-suppress PossiblyUnusedProperty
 */
class Awardit_Altapay_Model_Checkout_Type_PaymentMethod extends ArrayObject
{
    /**
     * Unique ID of the payment method
     *
     * @var string
     */
    public $id = '';
    /**
     * Type of payment method, defining the flow and capabilities
     *
     * @var string
     */
    public $type = '';
    /**
     * Payment method description.
     *
     * @var string
     */
    public $description = '';
    /**
     * URL to the logo of the payment method to be displayed on the merchant's website
     *
     * @var string
     */
    public $logoUrl = '';
    /**
     * The way the payment method is intended to be displayed at initialization
     *
     * @var string
     */
    public $display = '';
    /**
     * Definition of javascript handler used to perform the payment.
     *
     * @var array<string, mixed>
     */
    public $jsMethodHandler = [];
    /**
     * The action which will be executed after the payment method has been selected and customer decides to pay
     *
     * @var array<string, mixed>
     */
    public $onInitiatePayment = [];
    /**
     * The check which decides if the payment method should be render or not.
     *
     * @var array<string, mixed>
     */
    public $onRenderCheck = [];
    /**
     * Additional data that might be used for filtering and additional analytics
     *
     * @var array<string, string>
     */
    public $metadata = [];
    /**
     * Payment method name.
     *
     * @var string
     */
    public $name = '';

    public function __construct(array $data = array())
    {
        parent::__construct($data);
        foreach ($data as $key => $value) {
            $this->$key = $value;
        }
    }
}
