<?php

require_once __DIR__ . '/../vendor/autoload.php';

$username = 'joachim.wallsin@awardit.com';
$password = '';
$role = 'MERCHANT';
$request = new Awardit_Altapay_Model_Checkout_Type_AuthenticateRequest(['role' => $role]);

$config = new Awardit_Altapay_Model_Checkout_Configuration();
$config->setUsername($username);
$config->setpassword($password);

$client = Awardit_Altapay_Model_Checkout_Client::create($config);
$response = $client->authenticate($request);

$config->setAccessToken($response->token);

$createSessionBody = [
  'context' => [
    'browser' => [
      'origin' => 'https://sas.awarditstage.com'
    ]
  ]
];

$createSession = $client->createSession(new Awardit_Altapay_Model_Checkout_Type_Session($createSessionBody));
$sessionId = $createSession->sessionId;

$updateSessionBody = <<<JSON
{
    "order": {
        "orderId": "M6-123456",
        "amount": {
        "value": 100,
        "currency": "SEK"
        },
        "orderLines": [{
            "itemId": "123456789",
            "description": "A description of the item",
            "quantity": 1,
            "unitPrice": 100,
            "unitCode": "kg",
            "taxPercent": 23,
            "taxAmount": 95.1,
            "discountPercent": 15,
            "goodsType": "SHIPMENT",
            "imageUrl": "https://example.com/image.png",
            "productUrl": "https://example.com/image.png"
        }],
        "customer": {
            "firstName": "John",
            "lastName": "Doe",
            "email": "example@email.com",
            "phoneNumber": "4560020030",
            "billingAddress": {
                "firstName": "John",
                "lastName": "Doe",
                "street": "Gyngemose Parkvej 50",
                "city": "Copenhagen",
                "region": "Masovian Voivodeship",
                "country": "DK",
                "zipCode": "2800"
            },
            "shippingAddress": {
                "firstName": "John",
                "lastName": "Doe",
                "street": "Gyngemose Parkvej 50",
                "city": "Copenhagen",
                "region": "Masovian Voivodeship",
                "country": "DK",
                "zipCode": "2800"
            }
        }
    }
}
JSON;
$updateSession = $client->updateSession($sessionId, new Awardit_Altapay_Model_Checkout_Type_Session(json_decode($updateSessionBody, true)));

// Create new token with CUSTOMER role
$createAuthenticateRequest = new Awardit_Altapay_Model_Checkout_Type_AuthenticateRequest([
  'role' => 'CUSTOMER', 'sessionId' => $sessionId,
]);
$authenticate = $client->authenticate($createAuthenticateRequest);
$config->setAccessToken($response->token);
$client = Awardit_Altapay_Model_Checkout_Client::create($config);

$getSession = $client->getSession($sessionId);

$paymentMethods = $client->getPaymentMethods($sessionId);

$paymentMethodId = null;
foreach ($paymentMethods->methods as $paymentMethod) {
  if (stripos($paymentMethod->name, 'credit') > -1) {
    $paymentMethodId = $paymentMethod->id;
  }
}

$createPayment = $client->createPayment(new Awardit_Altapay_Model_Checkout_Type_CreatePaymentRequest(['sessionId' => $sessionId, 'paymentMethodId' => $paymentMethodId]));
$paymentId = $createPayment->paymentId;

$getPayment = $client->getPayment($paymentId);

var_dump(['getPayment', $getPayment, 'getSession', $getSession]);