<?php

use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class Awardit_Altapay_Model_Checkout_Normalizer_PaymentMethodResponseNormalizer implements
    DenormalizerInterface,
    NormalizerInterface,
    DenormalizerAwareInterface,
    NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;

    public function supportsDenormalization($data, string $type, ?string $format = null): bool
    {
        return $type === Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse::class;
    }

    public function supportsNormalization($data, ?string $format = null): bool
    {
        return is_object($data)
            && get_class($data) === Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse::class;
    }

    /**
     * Denormalize
     * @param mixed       $data    Data to restore
     * @param string      $type    The expected class to instantiate
     * @param string|null $format  Format the given data was extracted from
     * @param array       $context Options available to the denormalizer
     *
     * @return mixed
     */
    public function denormalize($data, string $type, ?string $format = null, array $context = [])
    {
        $object = new Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse();
        if (null === $data || false === is_array($data)) {
            return $object;
        }
        if (\array_key_exists('methods', $data)) {
            $values = [];
            foreach ($data['methods'] as $value) {
                $values[] = new Awardit_Altapay_Model_Checkout_Type_PaymentMethod($value);
            }
            /** @psalm-suppress InvalidPropertyAssignmentValue */
            $object->methods = $values;
            unset($data['methods']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }

    /**
     * Normalize
     * @param mixed       $object  Object to normalize
     * @param string|null $format  Format the normalization result will be encoded as
     * @param array       $context Context options for the normalizer
     *
     * @return array|string|int|float|bool|\ArrayObject|null
     * \ArrayObject is used to make sure an empty object is encoded as an object not an array
     */
    public function normalize($object, ?string $format = null, array $context = [])
    {
        $data = [];
        $values = [];
        foreach ($object->methods as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
            unset($object->methods);
        }
        $data['methods'] = $values;
        foreach ($object as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }
        return $data;
    }

    public function getSupportedTypes(): array
    {
        return [Awardit_Altapay_Model_Checkout_Type_PaymentMethodResponse::class => false];
    }
}
