<?php

use Awardit_Altapay_Model_Checkout_Exception_ClientException as Exception;

class Awardit_Altapay_Model_Checkout_Exception_NotFoundException extends RuntimeException implements Exception
{
    /** @var Awardit_Altapay_Model_Checkout_Type_ErrorResponse */
    private $errorResponse;

    public function __construct(
        string $message,
        Awardit_Altapay_Model_Checkout_Type_ErrorResponse $errorResponse
    ) {
        parent::__construct($message, 401);
        $this->errorResponse = $errorResponse;
    }

    public function getErrorResponse(): Awardit_Altapay_Model_Checkout_Type_ErrorResponse
    {
        return $this->errorResponse;
    }
}
