<?php

use Awardit_Altapay_Model_Checkout_Endpoint_Interface as EndpointInterface;
use Psr\Http\Message\ResponseInterface;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * @template T of ArrayObject|null
 * @psalm-suppress PossiblyUnusedProperty
 */
abstract class Awardit_Altapay_Model_Checkout_Endpoint_BaseApi implements EndpointInterface
{
    /** @var T */
    protected $body;

    abstract public function getMethod(): string;

    abstract public function getBody(SerializerInterface $serializer): string;

    abstract public function getUri(): string;

    abstract public function parseResponse(ResponseInterface $response, SerializerInterface $serializer);

    protected function getExtraHeaders(): array
    {
        return [];
    }

    public function getQueryString(): string
    {
        return '';
    }
}
