<?php

use Psr\Http\Message\ResponseInterface;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * @extends Awardit_Altapay_Model_Checkout_Endpoint_BaseApi<Awardit_Altapay_Model_Checkout_Type_Session|null>
 */
class Awardit_Altapay_Model_Checkout_Endpoint_CreateSession extends Awardit_Altapay_Model_Checkout_Endpoint_BaseApi
{
    /** @var Awardit_Altapay_Model_Checkout_Configuration */
    protected $config;

    /** @var Awardit_Altapay_Model_Checkout_Type_Session|null */
    protected $body;

    /**
     * @param Awardit_Altapay_Model_Checkout_Configuration $config
     */
    public function __construct(
        Awardit_Altapay_Model_Checkout_Configuration $config,
        ?Awardit_Altapay_Model_Checkout_Type_Session $requestBody = null
    ) {
        $this->config = $config;
        $this->body = $requestBody;
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function getUri(): string
    {
        return '/checkout/v1/api/session';
    }

    public function getHeaders(array $baseHeaders = []): array
    {
        $headers = ['Accept' => 'application/json', 'Content-Type' => 'application/json'];

        // this endpoint requires HTTP bearer token
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = sprintf('Bearer %s', $this->config->getAccessToken());
        }
        return array_merge($baseHeaders, $headers);
    }

    public function getBody(SerializerInterface $serializer): string
    {
        return $serializer->serialize($this->body, 'json');
    }

    /**
     * @param ResponseInterface $response
     * @param SerializerInterface $serializer
     * @return null|Awardit_Altapay_Model_Checkout_Type_Session
     */
    public function parseResponse(ResponseInterface $response, SerializerInterface $serializer)
    {
        $status = $response->getStatusCode();
        $contentType = $response->hasHeader('Content-Type') ? current($response->getHeader('Content-Type')) : null;
        $body = (string) $response->getBody();

        if ($status === 200 && $contentType === 'application/json') {
            return $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_Session', 'json');
        }
        if ($status === 400 && $contentType === 'application/json') {
            throw new Awardit_Altapay_Model_Checkout_Exception_BadRequestException(
                'Bad Request - missing or invalid request parameters.',
                $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_ErrorResponse', 'json')
            );
        }
        if ($status === 401 && $contentType === 'application/json') {
            throw new Awardit_Altapay_Model_Checkout_Exception_UnauthorizedException(
                'Unauthorized - missing or wrong JWT token.',
                $serializer->deserialize($body, 'Awardit_Altapay_Model_Checkout_Type_ErrorResponse', 'json')
            );
        }
    }
}
