<?php

namespace AltapayTests;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Mage;
use Mage_Sales_Model_Quote;
use PHPUnit\Framework\TestCase;

class QuoteTest extends TestCase
{
    public function setUp(): void
    {
        MagentoManager::reset();
        MagentoManager::init('default');
    }

    protected function createQuote(): Mage_Sales_Model_Quote
    {
        $quote = Mage::getModel("sales/quote");
        $quote->save();
        return $quote;
    }

    public function testReserveOrderId(): void
    {
        $firstQuote = $this->createQuote();
        $firstQuote->reserveOrderId();
        $firstQuote->save();
        $reservedOrderId = $firstQuote->getReservedOrderId();

        $secondQuote = $this->createQuote();
        $secondQuote->setReservedOrderId($reservedOrderId);
        $secondQuote->reserveOrderId();
        $secondQuote->save();
        $this->assertNotSame($reservedOrderId, $secondQuote->getReservedOrderId());
    }
}
